cd "${utils}"

forvalues y = 2004/2013 {
	
	local name = "STETA"
	if `y' > 2008 {
		local name = lower("`name'")
	}
	file open myfile using "${utils}\extract_REE.sas", write replace
	// Edit path to store resulting source datafile
	file write myfile `"libname REE "${rawsource}\REE_Stocks Etablissements_`y'";"' _n
	file write myfile `"proc export data = REE.`name'`=substr("`y'",3,2)'"' _n
	file write myfile `"outfile = '${tmp}\stock_`=substr("`y'",3,2)''"' _n
	file write myfile `"dbms = dta replace ; run; "'_n
	file close myfile

	shell "${SASPath}" "${utils}\extract_REE.sas"
	}


forvalues y = 2014/2019 {
	
	local name = "steta14"
	if `y' == 2015 {
		local name = "steta15"
	}
	if `y' == 2018 {
		local name = "stetab_31122017"
	}
	if `y' == 2017 {
		local name = "stetab_31122016"
	}
	if `y' == 2016 {
		local name = "stetab_31122015"
	}
	if `y' == 2019 {
		local name = "stetab_31122018"
	}
	file open myfile using "${utils}\extract_REE.sas", write replace
	// Edit path to store resulting source datafile
	file write myfile `"libname REE "${rawsource}\REE_Stocks Etablissements_`y'\Versions\V1\";"' _n
	file write myfile `"proc export data = REE.`name'"' _n
	file write myfile `"outfile = '${tmp}\stock_`=substr("`y'",3,2)''"' _n
	file write myfile `"dbms = dta replace ; run; "'_n
	file close myfile

	shell "${SASPath}" "${utils}\extract_REE.sas"
	}
	
	
	\\casd.fr\casdfs\Projets\IMPCRED\Data\REE_Stocks Etablissements_2015\Versions\V1
	
// post 2013 rawdata are in .parquet, run R script to convert them in dta

forvalues y = 2014/2014 {
	
	local inpath = "${rawsource}/\REE_Stocks Etablissements_`y'/STOCK_ETAB_`y'.parquet"
	local outpath = "${tmp}/STOCK_ETAB_`y'.csv"
	local file = "${utils}/parquet_to_csv.R"
	shell "${RPath}" "`file'" "`inpath'" "`outpath'" 12 > rlog.txt 2>&1"
	insheet using "${tmp}/STOCK_ETAB_`y'.csv", clear
	
	save "${tmp}/stock_`=substr("`y'",3,2)'", replace
	erase "${tmp}/STOCK_ETAB_`y'.csv"
}
	